<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PageContent extends Model
{
    protected $fillable = [
        'page_key',
        'section',
        'label',
        'content',
        'type',
    ];

    public static function getContent($key, $default = null)
    {
        $content = self::where('page_key', $key)->first();
        return $content ? $content->content : $default;
    }

    public static function setContent($key, $value, $section = null, $label = null, $type = 'text')
    {
        return self::updateOrCreate(
            ['page_key' => $key],
            [
                'section' => $section,
                'label' => $label ?: $key,
                'content' => $value,
                'type' => $type,
            ]
        );
    }
}
